<?php
//==============================================================
// class Dap_VBForumOps - intended to be used with vBulletin 3.7.2
// by Alex Matulich, June 2008, Unicorn Research Corporation
//
// Setup:
// ------
// Create a class called Dap_<pluginname>.class.php under /dap/plugins/<pluginname> folder
// For ex- for vbulletin plugin, create a class called Dap_Vbulletin.class.php under /dap/plugins/vbulletin folder
//
// In the DAP products page, when setting up the plugins to add/remove, call the plugin by the same name as the above <pluginname>
// For ex - you would add the following in DAP Products page for vbulletin
// 	Add_Vbulletin / Remove_Vbulletin  
//   (NOTE: capitalize the first lette of the plugin name)
//
// Dap will look for a folder called Vbulletin and a class called Dap_Vbulletin.class.php.
//
//	$lldocroot = defined('SITEROOT') ? SITEROOT : $_SERVER['DOCUMENT_ROOT'];
//	$filename = $lldocroot . '/dap/plugins/<pluginname>/Dap_<pluginame>.class.php';
//			
//		if (file_exists($filename)) { 
//			logToFile("plugin exists",LOG_INFO_DAP);
//			include_once ($filename);
				
//			$forum = new Dap_Vbulletin();
//	 		$errmsg = $forum->syncUser($userId, $productId, FALSE);
				
// Usage:
// ------
//		READ USER DETAILS FROM DAP
//		$dapuser = Dap_User::loadUserById($userId);
//		$username = $dapuser->getFirst_name();
//   
//		FETCH USER DETAILS FROM THE PLUGIN
//    Update the loadUser methos with everything needed to load user data from the plugin 
//    Sampke for VB  -  $vbulletin->userinfo = $forum->loadUser($dapuser);
//		
//		CREATE AND REGISTER NEW USER:
//    Update the registerUser method with everything needed to register user to the plugin
//		Sample for VB reg:   
//		$errmsg = $forum->registerUser ($dapuser, $vbulletin, $userId, $productId)
//
// 	UPDATE EXISTING USER DATA:
//		Update the updateUser method with everything needed to update user data to the plugin
//    $errmsg = $forum->updateUser($userdata);
//
//    $errmsg contains any error messages separated by <br> codes.
// 	If no errors occured then NULL is returned.
//
// 	DELETE USER:
//		Update the deleteUser method with everything needed to delete user cleanly from the plugin database
//    $forum->deleteUser($dapuser); 
//
// 	LOGIN USER TO THE FORUM:
//		Update the login method with everything needed to login userto the plugin including setting of the cookie for the plugin for auto-login
//    $forum->login($email)
//      
// 	LOG OFF USER FROM THE FORUM:
//		Update the logout method with everything needed to logout users from the plugin 
//    $forum->logout();
//

//===============================================================

define('REGISTERED_USERGROUP', 2); // typical default for registered users
define('THIS_SCRIPT', __FILE__);


//chdir(VBFORUMPATH);

//require_once('./includes/init.php'); // includes class_core.php
//require_once('./includes/class_dm.php'); // for class_dm_user.php
//require_once('./includes/class_dm_user.php'); // for user functions
//require_once('./includes/functions.php'); // vbsetcookie etc.
//require_once('./includes/functions_login.php'); // process login/logout

require_once(VBFORUMPATH.'/includes/init.php'); // includes class_core.php
if(defined('VBFORUMPATH')) {
	logToFile ("Dap_Vbulletin.class.php: VBFORUMPATH defined");
	if(strstr(VBFORUMPATH,"core")==TRUE) {
		logToFile ("Dap_Vbulletin.class.php: core not found in vbforumpath.. it's VB 5.x");
	}
	else {
		logToFile ("Dap_Vbulletin.class.php: VB 4.x detected");
		require_once(VBFORUMPATH.'/includes/class_dm.php'); // for class_dm_user.php
		require_once(VBFORUMPATH.'/includes/class_dm_user.php'); // for user functions
	}
}
else {
	logToFile ("Dap_Vbulletin.class.php: VBOFURMPATH NOT defined");
}

require_once(VBFORUMPATH.'/includes/functions.php'); // vbsetcookie etc.
require_once(VBFORUMPATH.'/includes/functions_login.php'); // process login/logout

//require_once(VBFORUMPATH.'/vb/api/user.php'); // process login/logout

//require_once("/home/public_html/forums/core/vb/user.php");
//---------------------------------------------------------------------
// CLASS Dap_VBForumOps
//---------------------------------------------------------------------
class Dap_Vbulletin extends vB_DataManager_User {
   var $userdm;
   
   function Dap_Vbulletin() // constructor
   {
      global $vbulletin;
	   $this->userdm =& datamanager_init('User', $vbulletin, ERRTYPE_ARRAY);
   }


   //======== USER REGISTRATION / UPDATE / DELETE ========
	// Add to VB if user not there,  update to VB if user exists
	function syncUser($userId, $productId, $login = false, $userNameChanged=false, $existingUser="")
	{
		//$newdap used in update dap profile usecase. It is required to hold the new update params because the updates would not have made it 
		//to dap DB at the time this function is called. The read from DB will still yield old values.
		
		global $vbulletin;
	
		$dapuser = Dap_User::loadUserById($userId);
		$email = trim($dapuser->getEmail());
		$username = trim($dapuser->getUser_name());
		$firstname = trim($dapuser->getFirst_name());
		$lastname = trim($dapuser->getLast_name());
		
		logToFile ("Dap_Vbulletin.class.php: syncUser(): USERID=" . $userId);
				
		logToFile ("Dap_Vbulletin.class.php: syncUser(): username=" . $username);
			
		logToFile ("Dap_Vbulletin.class.php: syncUser(): email=" . $email);


		if (!isset($username) || $username == "") {
			$username = $firstname.$lastname;
			logToFile ("Dap_Vbulletin.class.php: registerUser(): new reg, null username, update to firstname.lastname=" . $username);
			$dapuser->setUser_name($username);
			
			$vbulletin->userinfo = $this->loadUser($dapuser);
			if ($vbulletin->userinfo || $vbulletin->userinfo['username'] != "") {
				$existingUser = "Y";
			}
		}
		else {
			$vbulletin->userinfo = $this->loadUser($dapuser);
		}
		
		$updateUserName = "N";
		$registerUserName = "N";
		
		if ($existingUser != "") { //username changed
			logToFile ("Dap_Vbulletin.class.php: syncUser(): check if new username=" .  $username . " already exists in VB");
			if (!($vbulletin->userinfo)) { // new registration
				// check if dap email exists in VB, 
				$vbulletin->userinfo = $this->loadUserByEmail($dapuser);
				if (($vbulletin->userinfo) && ($vbulletin->userinfo['email'] != "")) { // emaail in use
					$oldUsername = $vbulletin->userinfo['username'];
					$str = "User = " . $email . " is already tied to a different username = " . $oldUsername . " in VB. DAP will now attempt to rename the old username=" . $oldUsername . " to new username=" . $username;
					logToFile ("Dap_VBulletin.class.php: syncUser() : " . $str);
					$updateUserName = "Y";
				}
				else {
					$registerUserName = "Y";	
				}
			}
			else {
				if (($vbulletin->userinfo['email'] != "") && ($vbulletin->userinfo['email'] == $email)) {
					$oldUsername = $vbulletin->userinfo['username'];
					$str = "User = " . $email . " is already tied to the same username = " . $oldUsername . " in VB. DAP will simply re-sync user=" . $username;
					logToFile ("Dap_VBulletin.class.php: syncUser() : " . $str);
					$updateUserName = "Y";
				}
				else {
					$str = "Username = " . $username . " is already in use by user = " . $vbulletin->userinfo['email'] . " in VB.";
					logToFile ("Dap_VBulletin.class.php: syncUser() : ERROR- " . $str);
					$response = "Sorry, Username= " . $username . " is already in use. Please pick another username";
					//send admin email
					return $response;
				}
			}
		}
		
		if (!($vbulletin->userinfo) || ($vbulletin->userinfo['username'] == "") || ($registerUserName == "Y")) {
			logToFile ("Dap_Vbulletin.class.php: syncUser(): new reg for user=" . $email);
			return ($this->registerUser($dapuser, $productId));
		}
		else { //existing user - new forum reg
			logToFile ("Dap_Vbulletin.class.php: syncUser(): existing user - update forum for user=" . $email);
			return ($this->updateUser($dapuser, $productId, $updateUserName));
		}
		
	}
		
	function deriveMemberGroupUsingProductAccess($newdap, $exclude="")
	{
		$userProducts = Dap_UsersProducts::loadProductsIgnoreStatus($newdap->getId());
		$create_membergroupIds = "";
		$primary="";
		foreach ($userProducts as $userProduct) 
		{ 
			logToFile ("Dap_Vbulletin.class.php: deriveMemberGroupUsingProductAccess, product_id=" . $userProduct->getProduct_id());	
			if(($exclude != "") && ($exclude == $userProduct->getProduct_id())) {
			  logToFile ("Dap_Vbulletin.class.php: deriveMemberGroupUsingProductAccess, EXCLUDE product_id=" . $userProduct->getProduct_id() . " from the final usergroup calculations");	
			  continue;  // used for removeAccess, get a list of all products user has but exclude the product being removed to derive final membergroup
			}
			$productForums = Dap_VBForum::loadProductForumMappingDataAndPriorityByProductId($userProduct->getProduct_id(), "AT");
			foreach ($productForums as $productForum) 
			{
				if ($productForum["target_operation"] != "R") {
	   if(($primary=="") && ((isset($productForum["priority"]) && ($productForum["priority"] != "") && ($productForum["priority"] != NULL)) ||  (!isset($productForum["priority"]) ))) {			
					  $primary=$productForum['target_usergroup_id'];
					  logToFile ("Dap_Vbulletin.class.php: deriveMemberGroupUsingProductAccess, PRIMARY FOUND=" . $primary);
					  $this->userdm->set('usergroupid', $productForum['target_usergroup_id']);
					  $this->userdm->set('membergroupids', $create_membergroupIds); 
					  continue;
					}
					else {
					  if ($create_membergroupIds == "") 
					  {
						  $create_membergroupIds = $productForum['target_usergroup_id'];
					  }
					  else if (strstr($create_membergroupIds, $productForum['target_usergroup_id']) == FALSE) {
						  $create_membergroupIds = $create_membergroupIds . "," . $productForum['target_usergroup_id'];
					  }
					}
				}
			}
		}
		
		logToFile ("Dap_Vbulletin.class.php: deriveMemberGroupUsingProductAccess, primary set to=" . $primary);	
		logToFile ("Dap_Vbulletin.class.php: deriveMemberGroupUsingProductAccess, create_membergroupIds=" . $create_membergroupIds);	
		
		if($primary == "") {
			if ($create_membergroupIds != "") {
				$this->setPrimaryAndSecondaryGroups ($create_membergroupIds);
			}
			else if ($create_membergroupIds == "") {
				if($exclude != "") { // if upon removeaccess, user ends up with no dap products, or with products that does not make the user forum eligible anymore, 
				  $this->userdm->set('membergroupids', ""); 	
				  if(defined('VBFORUM_DEFAULT_ACCESS')) {
					logToFile ("Dap_Vbulletin.class.php: deriveMemberGroupUsingProductAccess, primary set to =" . VBFORUM_DEFAULT_ACCESS . " from dap-config.php");	
				  	$this->userdm->set('usergroupid', VBFORUM_DEFAULT_ACCESS);
				  }
				  else {
					logToFile ("Dap_Vbulletin.class.php: deriveMemberGroupUsingProductAccess, primary set to NULL");	  
					$this->userdm->set('usergroupid', ""); 
				  }
				  
				  logToFile ("Dap_Vbulletin.class.php: deriveMemberGroupUsingProductAccess, removed access results in user losing access to all forum eligible products");	
				}
				else {
				  logToFile ("Dap_Vbulletin.class.php: deriveMemberGroupUsingProductAccess, no forum mapping rules found");	
			      return "no forum mapping rules found"; // no forum mapping rules found
				}
			}
		}
		else {
		  if ($create_membergroupIds != "") {
			  $this->userdm->set('membergroupids', $create_membergroupIds); 	
			  logToFile ("Dap_Vbulletin.class.php: deriveMemberGroupUsingProductAccess, FINAL create_membergroupIds=" . $create_membergroupIds);	
		  }
		}
		
		logToFile ("Dap_Vbulletin.class.php: deriveMemberGroupUsingProductAccess: before save");
		logToFile ("Dap_Vbulletin.class.php: deriveMemberGroupUsingProductAccess slowdown");
		
		$userid = $this->userdm->save();
		logToFile ("Dap_Vbulletin.class.php: deriveMemberGroupUsingProductAccess: after save");
		$count=0;

		if (count($this->userdm->errors)) {
			for($i=0; $i<count($this->userdm->errors); $i++)
			{
				 logToFile ("Dap_VBulletin.class.php: deriveMemberGroupUsingProductAccess: New registration error in VB, usergroupid=" .$this->userdm->errors[$i]);
			}
			$str = implode('<br>', $this->userdm->errors);
			
			logToFile ("Dap_VBulletin.class.php: deriveMemberGroupUsingProductAccess: VB Registration Error:  " . $str);
			return $str;
		}
		
		return 0;
	}
			
	
	function setPrimaryAndSecondaryGroups($groupIds) {
	// will only get called when no priority set	so no primary was set
	   if(strstr($groupIds,",")) {
		  $ary = explode(",", $groupIds);
		  $i=0;
		  $membergroupIds="";
		  $arrcount = count($ary);
		  foreach($ary as $key => $val) {
			  if ($i == 0) {$i++;continue;}
			  $membergroupIds = $membergroupIds . $ary[$key];
			  if ($i < $arrcount) {
				$membergroupIds = $membergroupIds . ",";
			  }
			  $i++;
		  }
		  
		  logToFile ("Dap_Vbulletin.class.php: registerUser(): calulated membergroupid=" . $membergroupIds);
		  logToFile ("Dap_Vbulletin.class.php: registerUser(): calulated primary id=" . $ary[0]);
		  $this->userdm->set('usergroupid', $ary[0]);
		  $this->userdm->set('membergroupids', $membergroupIds); 
		}
	}
	
	function registerUser ($dapuser, $productId)
	{
		global $vbulletin;
	
		$firstname = $dapuser->getFirst_name();
		$lastname = $dapuser->getLast_name();
		$username = $dapuser->getUser_name();
		$email = $dapuser->getEmail();
		$password = $dapuser->getPassword();
	
		$updateUserName = "N";
	    $membergroupIds = "";
		$primary="";
		
		$vbulletin->userinfo = $this->loadUserByEmail($dapuser);
		if ($vbulletin->userinfo && ($vbulletin->userinfo['username'] != $username)) {
				$str = "New email = " . $email . " is already in use by user = " . $vbulletin->userinfo['username'] . " in VB.";
				logToFile ("Dap_VBulletin.class.php: registerUser() : Email in use in VB but username is different " . $str);
				$response = "Email= " . $email . " is already in use by another user. Please pick another email";
				$this->userdm->set_existing($vbulletin->userinfo);	
		}
				
		$this->userdm->set('username', $username);
		$this->userdm->set('email', $email);
		$this->userdm->set('password', $password);
		
		logToFile ("Dap_Vbulletin.class.php: registerUser(): New registration in VB for user=" . $username . " productId=" . $productId);
		
		if ($productId != "") {
			$productForums = Dap_VBForum::loadProductForumMappingDataAndPriorityByProductId($productId, "AT");
			
			if (!isset($productForums) || ($productForums == NULL) or ($productForums == "")) {
				logToFile ("Dap_Vbulletin.class.php: registerUser(), No forum mapping rules found for productId=" . $productId);	
				return NULL;
			}
			
			foreach ($productForums as $productForum) {
				$targetAction =  $productForum["target_operation"];
				logToFile ("Dap_Vbulletin.class.php: registerUser(), target_usergroup_id" . $productForum['target_usergroup_id']);	
				logToFile ("Dap_Vbulletin.class.php: registerUser(), target action" . $targetAction);	
				
				if ($targetAction == "A") {
					if (strstr($membergroupIds, $productForum['target_usergroup_id']) == FALSE) { 
					
					    if(($primary=="") && ((isset($productForum["priority"]) && ($productForum["priority"] != "") && ($productForum["priority"] != NULL)) ||  (!isset($productForum["priority"]) ))) {
						    $primary=$productForum['target_usergroup_id'];
							$this->userdm->set('usergroupid', $primary);
							logToFile ("Dap_Vbulletin.class.php: registerUser(), PRIMARY SET TO=" . $primary);	 
						    continue;
						}
						else {
							if ($membergroupIds == "") {
								$membergroupIds = $productForum['target_usergroup_id'];
							}
							else if (strstr($membergroupIds, $productForum['target_usergroup_id']) == FALSE) {
								$membergroupIds = $membergroupIds . "," . $productForum['target_usergroup_id'];
							}
						}
					}
				}
			} //foreach
			
			logToFile ("Dap_Vbulletin.class.php: registerUser(), derived membergroupIds=" . $membergroupIds);			
			if($primary == "") {
			  if ($membergroupIds != "") {
				  $this->setPrimaryAndSecondaryGroups ($membergroupIds);
			  }
			  else if ($membergroupIds == "") {
				  logToFile ("Dap_Vbulletin.class.php: registerUser(), , no forum mapping rules found");	
				  return NULL; // no forum mapping rules found
			  }
			}
			else {
			  if ($membergroupIds != "") {
				$this->userdm->set('membergroupids', $membergroupIds); 	
				logToFile ("Dap_Vbulletin.class.php: registerUser(), , FINAL membergroupIds=" . $create_membergroupIds);	
			  }
			}
			
			$this->userdm->set_bitfield('options', 'adminemail', 1);
			$this->userdm->set_bitfield('options', 'showsignatures', 1);
			$this->userdm->set_bitfield('options', 'showavatars', 1);
			$this->userdm->set_bitfield('options', 'showimages', 1);
			$this->userdm->set_bitfield('options', 'showemail', 0);
			
			logToFile ("Dap_Vbulletin.class.php: registerUser(): before save, username=" . $username);
			$vbuserid = $this->userdm->save();
			logToFile ("Dap_Vbulletin.class.php: registerUser(): New registration in VB, username=" . $username);
			
			if (count($this->userdm->errors)) {
				for($i=0; $i<count($this->userdm->errors); $i++)
				 {
					 logToFile ("Dap_Vbulletin.class.php: registerUser(): New registration error in VB, usergroupid=" .$this->userdm->errors[$i]);
				 }
				 $str = implode('<br>', $this->userdm->errors);
				
				logToFile ("Dap_VBulletin.class.php: registerUser(): VB Registration Error:  " . $str);
				return $str;
			}
			
		}
		else {
			$membergroupIds=$this->deriveMemberGroupUsingProductAccess($dapuser);	
			if ($membergroupIds != 0) {
				logToFile ("Dap_Vbulletin.class.php: registerUser(), membergroupIds= -1, RETURN as no forum mapping rules found for productId=" . $productId);	
				return NULL;
			}
		}
	
		
		logToFile ("Dap_Vbulletin.class.php: registerUser(): VB New Registration successful for Forum group(s):" . $membergroupIds . " successful for the user:" . $email);
		
		return NULL;
	}
	
	function updateUser($dapuser, $productId, $updateUserName="", $updateEmail="", $removeAccess="Y")
    {
     	global $vbulletin;
      
		$username = $dapuser->getUser_name();
		$email = $dapuser->getEmail();
		$password = $dapuser->getPassword();
		
		if ($updateEmail != "") {
			$vbulletin->userinfo = $this->loadUserByEmail($dapuser);
			if ($vbulletin->userinfo && ($vbulletin->userinfo['username'] != $username)) {
				$str = "New email = " . $email . " is already in use by user = " . $vbulletin->userinfo['username'] . " in VB.";
				logToFile ("Dap_VBulletin.class.php: syncUser() : ERROR- " . $str);
				$response = "Sorry, email= " . $email . " is already in use by another user. Please pick another email";
				return $response;	
			}
		}
		
		$vbulletin->userinfo = $this->loadUser($dapuser);
		
		logToFile ("Dap_Vbulletin.class.php: updateUser(): Start: VB username=" . $vbulletin->userinfo['username'] . ", DAP username=" . $dapuser->getUser_name());
		logToFile ("Dap_Vbulletin.class.php: updateUser(): productId=" . $productId);
		
		if ($updateUserName != "") {
			$vbulletin->userinfo = $this->loadUserByEmail($dapuser);	
			if ($vbulletin->userinfo) {
				logToFile ("Dap_Vbulletin.class.php: updateUser(): loaded by email, found as expected");
			}
		}
		
		$this->userdm->set_existing($vbulletin->userinfo);	
				
		$this->userdm->set('username', $username);
		$this->userdm->set('email', $email);
		$this->userdm->set('password', $password);
		
		$derived_membergroupids=$this->deriveMemberGroupUsingProductAccess($dapuser, $removeAccess);	
		logToFile ("Dap_Vbulletin.class.php: updateUser(),derived_membergroupids =" . $derived_membergroupids);
		
		if ($derived_membergroupids != 0) {
			logToFile ("Dap_Vbulletin.class.php: updateUser(), membergroupIds= -1, SAVE without resetting membergroupid as no forum mapping rules found for user=".$email);	
			logToFile ("Dap_Vbulletin.class.php: updateUser(): before save");
			$userid = $this->userdm->save();
			logToFile ("Dap_Vbulletin.class.php: updateUser(): after save");
		}
			
		// reset password cookie in case password changed
		$sitename=SITE_URL_DAP;
		
		$sitename=strtok($sitename,"http://");
		if(strstr($sitename,"www."))
			$sitename=strtok($sitename,"www.");
		
		logToFile ("Dap_Vbulletin.class.php: updateUser(): " . $sitename);

		//Might have to check if admin changing profile for another user before setting cookie here
				
		$domain = $this->getDomain();
		if (!isset($domain) || trim($domain) == "") {
			$str = "Dap_Vbulletin.class.php.login(): VB cookie cannot be set because the SITE_URL_DAP in dap-config.php is not in http://yoursite.com or http://www.yoursite.com format";
			logToFile ($str);
         return $str;
		}
		
		setcookie(COOKIE_PREFIX . 'password', md5($vbulletin->userinfo['password'].COOKIE_SALT),  time() + 3600 * 24, '/', $domain);			
		return NULL;
   }
	
	//---------------------------------------------------------------------
	// This function duplicates the functionality of fetch_userinfo(),
	// using the user name instead of numeric ID as the argument.
	// See comments in includes/functions.php for documentation.
	//---------------------------------------------------------------------
	function loadUser(&$dapuser)
	{
		global $vbulletin;
		
		$firstname = $dapuser->getFirst_name();
		$lastname = $dapuser->getLast_name();
		
		$username =  $dapuser->getUser_name();
		
		if (!isset($username) || $username == "")
			$username=$firstname . $lastname;
		
		$useridq = $vbulletin->db->query_first_slave("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username='{$username}'");
					
		if (!$useridq) {
			logToFile ("Dap_VBulletin.class.php: loadUser(): No user found for username=" . $username . " in VB");	
			return $useridq;
		}
		
		$option=0;
		$languageid=0;
		$userid = $useridq['userid'];
		return fetch_userinfo($userid, $option, $languageid);
	}
	
	function loadUserByEmail(&$dapuser)
	{
		global $vbulletin;
		
		$firstname = $dapuser->getFirst_name();
		$lastname = $dapuser->getLast_name();
		
		$username =  $dapuser->getUser_name();
		
		logToFile ("Dap_VBulletin.class.php: loadUser(): username=" . $username . " in VB");	
		
		if (!isset($username) || $username == "")
			$username=$firstname . $lastname;
		
		$email = $dapuser->getEmail();
		
		logToFile ("Dap_VBulletin.class.php: loadUser(): emailis already tied to a different username=" . $email . " in VB");	
				
		$useridq = $vbulletin->db->query_first_slave("SELECT userid FROM " . TABLE_PREFIX . "user WHERE email='{$email}'");
					
		if (!$useridq) {
			logToFile ("Dap_VBulletin.class.php: loadUser(): No user found for email=" . $email . " in VB");	
			return $useridq;
		}
		
		$option=0;
		$languageid=0;
		$userid = $useridq['userid'];
		return fetch_userinfo($userid, $option, $languageid);
	}
	
	
   function removeAccess($userId, $productId)
   {
      	global $vbulletin;
      	
		$dapuser = Dap_User::loadUserById($userId);
		logToFile ("Dap_VBulletin.class.php: removeAccess(): call updateUser to set the users usergroup in VB based on the current set of users products in dap");	
		$this->updateUser($dapuser, $productId, "", "", $productId);
		
		return NULL;
   }

   function deleteUser($dapuser)
   {
   // The vBulletin documentation suggests using userdm->delete()
   // to delete a user, but upon examining the code, this doesn't
   // delete everything associated with the user.  The following
   // is adapted from admincp/user.php instead.
   // NOTE: THIS MAY REQUIRE MAINTENANCE WITH NEW VBULLETIN UPDATES.
		global $vbulletin;
		/*
		$vbulletin->userinfo = $this->loadUserByEmail($dapuser);
		
		if (!($vbulletin->userinfo)) {
			$str = "Dap_VBulletin.class.php: deleteUser(): username=" . $username . " not found in VB";
			logToFile ($str);	
         return $str;
		}
		
		$this->userdm->set_existing(&$vbulletin->userinfo);	
		logToFile ("prior to delete");	
         
		$ret = $this->userdm->delete();
		logToFile ("after delete");
		return NULL;*/
    }

   // ======== USER LOGIN / LOGOUT ========
   function login($email,$password="")
   {
		global $vbulletin;
		
		$dapuser = Dap_User::loadUserByEmail($email);
		$firstname = $dapuser->getFirst_name();
		$lastname = $dapuser->getLast_name();
		
		$username =  $dapuser->getUser_name();
		
		
		if (!isset($username) || $username == "") {
			$username = $firstname.$lastname;
			$dapuser->setUser_name($username);
		}
		
		if (!isset($username) || $username == "") {
			$str = "Dap_Vbulletin.class.php.login(): Missing username=" . $username . " in dap, user not registered in VB";
			logToFile ($str);
			return $str;				
		}
			
		logToFile ("Dap_Vbulletin.class.php.login(): Enter: fetch vb user info, username = " . $username);
			
		if (!($vbulletin->userinfo = $this->loadUser($dapuser))) {
			$str = "Dap_Vbulletin.class.php.login(): loadUser() failed for username=" . $username;
			logToFile ($str);
	        return $str;
		}
		
		$domain = $this->getDomain();
		if (!isset($domain) || trim($domain) == "") {
			$str = "Dap_Vbulletin.class.php.login(): VB cookie cannot be set because the SITE_URL_DAP in dap-config.php is not in http://yoursite.com or http://www.yoursite.com format";
			logToFile ($str);
         return $str;
		}
		
		logToFile ("Dap_Vbulletin.class.php.login(): username=" . $username . ", password=".$password);
		
		
		//process_new_login('', false, '');
		if(strstr(VBFORUMPATH,"core")==TRUE) { // vb5
		  $auth = vB_User::verifyAuthentication($username, $password, null, null);
		  vB_User::execUnstrikeUser($username);
		
		  // create new session
		  if($auth) {			logToFile ("Dap_Vbulletin.class.php.auth: " . $auth);			
			  //$res = vB_User::processNewLogin($auth, $logintype);
			$res = vB_User::processNewLogin($auth, $vbulletin->GPC['logintype'], $vbulletin->GPC['cssprefs']);						logToFile ("Dap_Vbulletin.class.php.red: " . $res);					
			if(!$res) {
				logToFile ("Dap_Vbulletin.class.php.login(): ");
				$str = "Dap_Vbulletin.class.php.login():processNewLogin: Login Failed";
				logToFile ($str);
				return $str;
			}
			if ($_SESSION["dapRememberMe"] != "") {
			  $i=14;
			  setcookie(COOKIE_PREFIX . 'userid', $vbulletin->userinfo['userid'], time() + 3600 * 24 * $i, '/', $domain);
			  setcookie(COOKIE_PREFIX . 'password', md5($vbulletin->userinfo['password'].COOKIE_SALT),  time() + 3600 * 24 * $i, '/', $domain);
			  setcookie(COOKIE_PREFIX . 'sessionhash', $res['sessionhash'],  time() + 3600 * 24 * $i, '/', $domain);
			}
			else {
			  setcookie(COOKIE_PREFIX . 'userid', $vbulletin->userinfo['userid'], time() + 3600 * 24, '/', $domain);
			  setcookie(COOKIE_PREFIX . 'password', md5($vbulletin->userinfo['password'].COOKIE_SALT),  time() + 3600 * 24, '/', $domain);
			  setcookie(COOKIE_PREFIX . 'sessionhash', $res['sessionhash'],  time() + 3600 * 24, '/', $domain);
			}
			
		  }
		  else {
			  logToFile ("Dap_Vbulletin.class.php.login(): ");
			  $str = "Dap_Vbulletin.class.php.login(): could not authenticate the user. Login Failed";
			  logToFile ($str);
			  return $str;
		  }
		} // vb5+
		else { //vb4+
			if ($_SESSION["dapRememberMe"] != "") {
				$i=14;
				setcookie(COOKIE_PREFIX . 'userid', $vbulletin->userinfo['userid'], time() + 3600 * 24 * $i, '/', $domain);
				setcookie(COOKIE_PREFIX . 'password', md5($vbulletin->userinfo['password'].COOKIE_SALT),  time() + 3600 * 24 * $i, '/', $domain);
			}
			else {
				setcookie(COOKIE_PREFIX . 'userid', $vbulletin->userinfo['userid'], time() + 3600 * 24, '/', $domain);
				setcookie(COOKIE_PREFIX . 'password', md5($vbulletin->userinfo['password'].COOKIE_SALT),  time() + 3600 * 24, '/', $domain);
			}
			
			process_new_login('', false, '');
		}
		
		//$ret = vB_User::processNewLogin($username,$password);
		
		
		
		//process_new_login('', false, '');
		
		logToFile ("Dap_Vbulletin.class.php.login(): successfully logged into vB Forum");
		return NULL;
  	}
	
   function logout()
   {
      process_logout(); // unsets all cookies and session data
   }

   function getDomain() {
		$siteurl = SITE_URL_DAP;
		
		if (strstr ($siteurl, "www") ) {
			$url  = str_replace('http://www.', '', strtolower($siteurl));
		}
		else {
			$url  = str_replace('http://', '', strtolower($siteurl));
		}
		logToFile ("Dap_Vbulletin.class.php.getDomain(): url=" . $url);
		return $url;
	}

   function getDomainOLD(){
	  $url = SITE_URL_DAP;
	  
	  $urlData = parse_url($url);
	  $hostData = explode('.', $urlData['host']);
	  $hostData = array_reverse($hostData);
	  
	  if(array_search($hostData[1] . '.' . $hostData[0], $urlMap) !== FALSE) {
		$host = $hostData[2] . '.' . $hostData[1] . '.' . $hostData[0];
	  } elseif(array_search($hostData[0], $urlMap) !== FALSE) {
		$host = $hostData[1] . '.' . $hostData[0];
	  }
	  
	  logToFile ("Dap_Vbulletin.class.php.getDomain(): host=" . $host);
	  return $host;
	}
	
	function getDomain1() {
		$str = SITE_URL_DAP;
		
		if (strstr ($str, "www.") ) {
			$domain = explode('www.', $str);
		}
		else if (strstr ($str, "http://") ) {
			$domain = explode('http://', $str);
		}
			
		logToFile ("Dap_Vbulletin.class.php.getDomain(): sitename=" . $domain[1]);
		
		return $domain[1];
	}
		
} // end class Dap_VBForumOps

//chdir($cwd);
?>