<?php

class sendreach {

   function sendreach() // constructor
   {
   }

   //======== USER REGISTRATION / UPDATE / DELETE ========
	// Add if user not there,  else update 
	function register($userId, $productId, $params)
	{
		logToFile("sendreach.class.php: register(): calling storeAddress", LOG_INFO_DAP);
		
		$this->storeAddress($userId, $productId, $params);
	}
		
	function storeAddress($userId, $productId, $params){
		
		$dapuser = Dap_User::loadUserById($userId);
		$email = trim($dapuser->getEmail()); //required
		$username = trim($dapuser->getUser_name());
		$first_name = trim($dapuser->getFirst_name());  //optional but highly suggested
		$last_name = trim($dapuser->getLast_name()); //optional but highly suggested
		$password = $dapuser->getPassword();
		$client_ip = getIpOfUser(); //required
		
	
		
		$data = explode(":",$params);
		
		logToFile("sendreach.class.php: storeAddress(): email =" . $email, LOG_INFO_DAP);
		
		if(!preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*$/i", $email)) {
			logToFile("sendreach.class.php: storeAddress(): invalid email", LOG_INFO_DAP);
			return "Email address is invalid"; 
		}
	
		// set your API details here
		// You can find your userid under SendReach.com > Account Settings > Developers
		//key:secret:userid:listid
		
		$api_vars['key'] = $data[1]; 
		$api_vars['secret'] = $data[2];
		$api_vars['userid'] = $data[3];; // this is the userid that created the API application.
		
		require_once('classes.php');
		
		logToFile("sendreach.class.php: storeAddress(): key =" . $api_vars['key'], LOG_INFO_DAP);
		logToFile("sendreach.class.php: storeAddress(): secret =" . $api_vars['secret'], LOG_INFO_DAP);
		logToFile("sendreach.class.php: storeAddress(): userid =" . $api_vars['userid'], LOG_INFO_DAP);
		
		
		// grab an API Key from http://admin.sendreach.com/account/api/
		$sendreach = new api();
		
		$list_id = $data[4]; // list to subscriber new user too
		logToFile("sendreach.class.php: storeAddress(): list_id =" . $list_id, LOG_INFO_DAP);
		
		if(!isset($sendreach)) {
			logToFile("sendreach.class.php: not set", LOG_INFO_DAP);
			return;
		}
		
		$subscriber_add = $sendreach->subscriber_add($list_id,$first_name,$last_name,$email,$client_ip,$api_vars['key'],$api_vars['secret'],$api_vars['userid']); // the data is returned in json format
		if(isset($subscriber_add)) {
			$subscriber_add = json_decode($subscriber_add); // here we convert the json data into a PHP array
			//foreach ($subscriber_add as $i => $value) {
			  logToFile("sendreach.class.php: listSubscribe(): success: " . $subscriber_add->{'error'}, LOG_INFO_DAP);
			  logToFile("sendreach.class.php: listSubscribe(): success: " . $subscriber_add->{'status'}, LOG_INFO_DAP);		 	//}
		  //logToFile("sendreach.class.php: storeAddress(): subscriber_add =" . $subscriber_add, LOG_INFO_DAP);
		}
		else {
		  logToFile("sendreach.class.php: listSubscribe(): failed, empty object returned", LOG_INFO_DAP);
		}
		
		return 0;
		
	}
	
	function unregister($userId, $productId, $params)
	{
		logToFile("sendreach.class.php: register(): calling storeAddress", LOG_INFO_DAP);
		
		$this->removeAddress($userId, $productId, $params);
	}
	
	
	function removeAddress($userId, $productId, $params){
		
		$dapuser = Dap_User::loadUserById($userId);
		$email = trim($dapuser->getEmail());
	
		$data = explode(":",$params);
		
		logToFile("sendreach.class.php: removeAddress(): email =" . $email, LOG_INFO_DAP);
		
		if(!preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*$/i", $email)) {
			return "Email address is invalid"; 
		}
	
		require_once('classes.php');
		
		$api_vars['key'] = $data[1]; 
		$api_vars['secret'] = $data[2];
		$api_vars['userid'] = $data[3];; // this is the userid that created the API application.
		
		require_once('classes.php');
		
		logToFile("sendreach.class.php: storeAddress(): key =" . $api_vars['key'], LOG_INFO_DAP);
		logToFile("sendreach.class.php: storeAddress(): secret =" . $api_vars['secret'], LOG_INFO_DAP);
		logToFile("sendreach.class.php: storeAddress(): userid =" . $api_vars['userid'], LOG_INFO_DAP);
		
		
		// grab an API Key from http://admin.sendreach.com/account/api/
		$sendreach = new api();
		
		$list_id = $data[4]; // list to subscriber new user too
		logToFile("sendreach.class.php: storeAddress(): list_id =" . $list_id, LOG_INFO_DAP);
		
		if(!isset($sendreach)) {
			logToFile("sendreach.class.php: not set", LOG_INFO_DAP);
			return;
		}
		
		$subscriber_remove= $sendreach->subscriber_unsubscribe($hash,$api_vars['key'],$api_vars['secret'],$api_vars['userid']); // the data is returned in json format
		if(isset($subscriber_remove)) {
			$subscriber_remove = json_decode($subscriber_remove); // here we convert the json data into a PHP array
			//foreach ($subscriber_add as $i => $value) {
			  logToFile("sendreach.class.php: subscriber_unsubscribe(): success: " . $subscriber_remove->{'error'}, LOG_INFO_DAP);
			  logToFile("sendreach.class.php: subscriber_unsubscribe(): success: " . $subscriber_remove->{'status'}, LOG_INFO_DAP);		 	//}
		  //logToFile("sendreach.class.php: storeAddress(): subscriber_add =" . $subscriber_add, LOG_INFO_DAP);
		}
		else {
		  logToFile("sendreach.class.php: subscriber_unsubscribe(): failed, empty object returned", LOG_INFO_DAP);
		}
		
		
		return 0;
	
	}
			
} 
?>