<?php

class oap {

   function oap() // constructor
   {
   }

   //======== USER REGISTRATION / UPDATE / DELETE ========
	// Add if user not there,  else update 
	function register($userId, $productId, $params)
	{
		logToFile("oap.class.php: register(): calling storeAddress", LOG_INFO_DAP);
		
		$this->storeAddress($userId, $productId, $params);
	}
		
	function storeAddress($userId, $productId, $params){
		
		$dapuser = Dap_User::loadUserById($userId);
		$email = trim($dapuser->getEmail());
		$username = trim($dapuser->getUser_name());
		$firstname = trim($dapuser->getFirst_name());
		$lastname = trim($dapuser->getLast_name());
		$password = $dapuser->getPassword();
		
		$data = explode(":",$params);
		
		logToFile("oap.class.php: storeAddress(): email =" . $email, LOG_INFO_DAP);
		
		if(!preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*$/i", $email)) {
			logToFile("oap.class.php: storeAddress(): invalid email", LOG_INFO_DAP);
			return "Email address is invalid"; 
		}
	
		//require_once('MCAPI.class.php');
		
		// grab an API Key from http://admin.oap.com/account/api/
		$appid = $data[1];
		logToFile("oap.class.php: storeAddress(): appid =" . $appid, LOG_INFO_DAP);
		
		$key = $data[2];
		logToFile("oap.class.php: storeAddress(): key =" . $key, LOG_INFO_DAP);
		
		if(isset($data[3]))
			$groupname=$data[3];
			
		if(isset($data[4]))
			$sequencename=$data[4];

	
		// Construct contact data in XML format
		$data = '<contact>
		<Group_Tag name="Contact Information">
		<field name="First Name">'.$dapuser->getFirst_name().'</field>
		<field name="Last Name">'.$dapuser->getLast_name().'</field>
		<field name="E-Mail">'.$dapuser->getEmail().'</field>
		</Group_Tag>
		<Group_Tag name="Sequences and Tags">';
		if($groupname!="")
			$data .= '<field name="Contact Tags">' . $groupname . '</field>';
		if($sequencename!="")
			$data .= '<field name="Sequences">' . $sequencename . '</field>>';
		$data .= '</Group_Tag></contact>';


		$data = urlencode($data);
		
		//Set your request type and construct the POST request
		$reqType= "add";
		$postargs = "appid=".$appid."&key=".$key."&return_id=1&reqType=".$reqType. "&data=" . $data;
		$request = "http://api.moon-ray.com/cdata.php";
		
		//Start the curl session and send the data
		$session = curl_init($request);
		curl_setopt ($session, CURLOPT_POST, true);
		curl_setopt ($session, CURLOPT_POSTFIELDS, $postargs);
		curl_setopt($session, CURLOPT_HEADER, false);
		curl_setopt($session, CURLOPT_RETURNTRANSFER, true);
		
		//Store the response from the API for confirmation or to process data
		$response = curl_exec($session);
		
		//Close the session
		curl_close($session);
		logToFile("oap.class.php: storeAddress(): response =" . $response, LOG_INFO_DAP);
				return $response;
	}
	
	function unregister($userId, $productId, $params)
	{
		logToFile("oap.class.php: register(): calling searchContact", LOG_INFO_DAP);
		$contact_id=$this->searchContact($userId, $productId, $params);
		$this->removeAddress($userId, $productId, $params,$contact_id);
	}
	
	function searchContact($userId, $productId, $params) { //Search Contact
		$dapuser = Dap_User::loadUserById($userId);
		$data = explode(":",$params);
			
		logToFile("oap.class.php: searchContact(): email =" . $email, LOG_INFO_DAP);
		// grab an API Key from http://admin.oap.com/account/api/
		$appid = $data[1];
		logToFile("oap.class.php: searchContact(): appid =" . $appid, LOG_INFO_DAP);
		
		$key = $data[2];
		logToFile("oap.class.php: searchContact(): key =" . $key, LOG_INFO_DAP);
	
		$data = '		
		<search>
		<equation>
		<field>E-Mail</field>
		<op>e</op>
		<value>'.$email = trim($dapuser->getEmail()).'</value>
		</equation>
		</search>';
		$data = urlencode($data);
	
	
		$reqType = "search";
		$postargs = "appid=".$appid."&key=".$key."&reqType=".$reqType."&data=".$data;
		$request = "https://api.moon-ray.com/cdata.php";
		
		$session = curl_init($request);
		curl_setopt ($session, CURLOPT_POST, true);
		curl_setopt ($session, CURLOPT_POSTFIELDS, $postargs);
		curl_setopt ($session, CURLOPT_HEADER, false);
		curl_setopt ($session, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($session);
		curl_close($session);
		//header("Content-Type: text/xml");
		//echo $response;
		logToFile("oap.class.php: searchContact(): response =" . $response, LOG_INFO_DAP);
				//return $response;
		$xml = simplexml_load_string($response);
		foreach ($xml->contact as $id) { //Start Foreach
		//echo $movies->movie[0]->title&nbsp;id;
		logToFile("oap.class.php: searchContact(): response =" . $id['id'], LOG_INFO_DAP);
		return $contact_id=$id['id'];
		} //End foreach


	} //End search contact
	
	function removeAddress($userId, $productId, $params,$contact_id){ //Remove Address
		$dapuser = Dap_User::loadUserById($userId);
		$email = trim($dapuser->getEmail());
		$username = trim($dapuser->getUser_name());
		$firstname = trim($dapuser->getFirst_name());
		$lastname = trim($dapuser->getLast_name());
		$password = $dapuser->getPassword();
		
		$data = explode(":",$params);	

		logToFile("oap.class.php: removeAddress(): email =" . $email, LOG_INFO_DAP);
		
		// grab an API Key from dap config notify tab
		$appid = $data[1];
		logToFile("oap.class.php: removeAddress(): appid =" . $appid, LOG_INFO_DAP);
		
		$key = $data[2];
		logToFile("oap.class.php: removeAddress(): key =" . $key, LOG_INFO_DAP);
	
	
		// Construct contact data in XML format
		$data = '
		<contact_id>'.$contact_id.'</contact_id>
		';
		
		$reqType= "delete";
		$data = urlencode($data);
		$postargs = "appid=".$appid."&key=".$key."&reqType=".$reqType. "&data=".$data;
		$request = "https://api.moon-ray.com/cdata.php";
		
		$session = curl_init($request);
		curl_setopt ($session, CURLOPT_POST, true);
		curl_setopt ($session, CURLOPT_POSTFIELDS, $postargs);
		curl_setopt($session, CURLOPT_HEADER, false);
		curl_setopt($session, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($session);
		curl_close($session);
		
		logToFile("oap.class.php: storeAddress(): response =" . $response, LOG_INFO_DAP);
		return $response;
	} //End remove address		
			
} 
?>