(function() {
	tinymce.create('tinymce.plugins.buttonPlugin', {
		init : function(ed, url) {
			// Register commands
			ed.addCommand('mcebutton', function() {
				ed.windowManager.open({
					title : 'Add ListBuilderPopupContentEditor Button',
					file : url + '/listbuilderpopupcontenteditor_manager.php', // file that contains HTML for our modal window
					width : 950 + parseInt(ed.getLang('button.delta_width', 0)), // size of our window
					height : 700 + parseInt(ed.getLang('button.delta_height', 0)), // size of our window
					inline : 1,
					resizable:true
					
				}, {
					plugin_url : url
				});
			});
			 
			// Register buttons
			ed.addButton('listbuilderpopupeditor_button', {title : 'List Builder Popup', cmd : 'mcebutton', image: url + '/includes/images/listbuilderpopupeditor.png' });
		},
		 
		getInfo : function() {
			return {
				longname : 'Insert Button',
				author : 'Veena Prahsanth',
				authorurl : 'http://WickedCoolPlugins.com',
				infourl : 'http://WickedCoolPlugins.com',
				version : tinymce.majorVersion + "." + tinymce.minorVersion
			};
		}
	});
	 
	// Register plugin
	// first parameter is the button ID and must match ID elsewhere
	// second parameter must match the first parameter of the tinymce.create() function above
	tinymce.PluginManager.add('listbuilderpopupeditor_button', tinymce.plugins.buttonPlugin);

})();