(function() {
	tinymce.PluginManager.requireLangPack('wp_headline_shortcodes');
	tinymce.create('tinymce.plugins.wp_headline_shortcodes', {
		init : function(ed, url) {

			ed.addCommand('mcewp_headline_shortcodes', function() {
				ed.windowManager.open({
					file : url + '/../interface/interface.php',
					width : 585 + ed.getLang('wp_headline_shortcodes.delta_width', 0),
					height : 440 + ed.getLang('wp_headline_shortcodes.delta_height', 0),
					inline : 1
				}, {
					plugin_url : url
				});
			});

			
			ed.addButton('wp_headline_shortcodes', {
				title : 'wp_headline_shortcodes.desc',
				cmd : 'mcewp_headline_shortcodes',
				image : url + '/../images/btn.png'
			});

			
			ed.onNodeChange.add(function(ed, cm, n) {
				cm.setActive('wp_headline_shortcodes', n.nodeName == 'IMG');
			});
		},
		
		createControl : function(n, cm) {
			return null;
		},
		getInfo : function() {
			return {
					longname  : 'wp_headline_shortcodes',
					author 	  : 'Mohammad Fani',
					authorurl : 'http://www.softgridcomputers.com',
					infourl   : 'http://www.softgridcomputers.com',
					version   : "1.0"
			};
		}
	});
	tinymce.PluginManager.add('wp_headline_shortcodes', tinymce.plugins.wp_headline_shortcodes);
})();


