<?php
	/* Load Admin CSS */
	function KillerAdminInit() 
	{
		$directory_file=get_bloginfo('template_directory');
		//wp_enqueue_script('media-upload');
		//wp_enqueue_script('thickbox');
		wp_register_style('wpheadline-css', WP_HEADLINE_PLUGIN_URL.'/css/style.css');
		wp_enqueue_style('wpheadline-css');
		wp_register_script('wpheadline-js', WP_HEADLINE_PLUGIN_URL.'/js/admin-script.js', array('jquery'));
		wp_enqueue_script('wpheadline-js');
	}
	add_action('admin_head', 'KillerAdminInit');
	/* Add Settings Page */
	add_action('admin_init', 'wpheadline_settings_init' );
	add_action('admin_menu', 'wpheadline_settings_add_page');

	// Init plugin options to white list our options
	function wpheadline_settings_init(){
		register_setting( 'wpheadline_settings_options', 'wpheadline_options', 'wpheadline_settings_validate' );
	}

	// Add menu page
	function wpheadline_settings_add_page() {
		add_options_page('WPHeadline Settings', 'WPHeadline Settings', 'manage_options', 'wpheadline_settings', 'wpheadline_settings_do_page');
	}

	// Draw the menu page itself
	function wpheadline_settings_do_page() {
		?>
		<div class="wrap">
			<div id="icon-options-general" class="icon32"><br></div>
			<h2>WPHeadline Settings</h2>
			<form method="post" action="options.php">
				<?php settings_fields('wpheadline_settings_options'); ?>
				<?php $options = get_option('wpheadline_options'); ?>
				<table class="form-table">
					<tr valign="top"><th scope="row">Font Server</th>
						<td><input type="text" name="wpheadline_options[font_server]" value="<?php echo $options['font_server']; ?>" class="regular-text" /> <span class="description">Enter font server URL (Leave blank to use default).</span></td>
					</tr>
				</table>
				<p class="submit">
				<input type="submit" class="button-primary" value="<?php _e('Save Changes') ?>" />
				</p>
			</form>
		</div>
		<?php	
	}

	// Sanitize and validate input. Accepts an array, return a sanitized array.
	function wpheadline_settings_validate($input) {
		
		// server url option must be safe text with no HTML tags
		$input['font_server'] =  wp_filter_nohtml_kses($input['font_server']);
		
		return $input;
	}
	/* settings ends */
	//add_action('admin_menu', 'wp_headline_pages_advert');
	function wp_headline_pages_advert()
	{
		$directory_file=WP_HEADLINE_PLUGIN_URL;
		
		add_menu_page(__('WP Headline','wp-headline'), __('WP Headline','menu-wp-headline'), 'manage_options', 'wp-headline-dashboard', 'wp_headline_dashboard_page',$directory_file.'favicon.ico',6 );
	
		/*add_submenu_page('wp-headline-dashboard', __('Addons','wp-headline-addons'), __('Addons','menu-wp-headline-addons'), 'manage_options', 'wp-headline-addons', 'wp_headline_addons_page');*/
		
		add_submenu_page('wp-headline-dashboard', __('Gallery','wp-headline-gallery'), __('Gallery','menu-wp-headline-gallery'), 'manage_options', 'wp-headline-gallery', 'wp_headline_gallery_page');
		
		add_submenu_page('wp-headline-dashboard', __('Training','wp-headline-training'), __('Training','menu-wp-headline-training'), 'manage_options', 'wp-headline-training', 'wp_headline_training_page');
	  
	}
	function wp_headline_dashboard_page()
	{
		//echo '<iframe src="http://members.wpheadline.com/news/" id="wpheadline-dashboard">Loading...</iframe>';
		?>
		<script type="text/javascript">
			window.open("http://members.wpheadline.com/news/","dashboard_window");
        </script>
        <?php
	}
	/*function wp_headline_addons_page()
	{
		echo '<iframe src="http://www.westrivers.com/wpheadlinecode/frame/addon.html" id="wpheadline-addon">Loading...</iframe>';
	}*/
	function wp_headline_gallery_page()
	{
		//echo '<iframe src="http://members.wpheadline.com/gallery/" id="wpheadline-gallery">Loading...</iframe>';
		?>
		<script type="text/javascript">
			window.open("http://members.wpheadline.com/gallery/","gallery_window");
        </script>
        <?php
	}
	function wp_headline_training_page()
	{
		//echo '<iframe src="http://members.wpheadline.com/training/" id="wpheadline-training">Loading...</iframe>';
		?>
		<script type="text/javascript">
			window.open("http://members.wpheadline.com/training/","training_window");
        </script>
        <?php
        
	}
?>