<?php
class SFEditor
{
	static private $controls;
	static private $scripts;
	static private $styles;
	
	const heading='heading'; //array('headings'=>1, 'underlines'=>2, 'backgrounds'=>3, 'fonts'=>4);
	const underline='underline';
	const background='background';
	const font='font';
	const color='color';
	const warning='warning';
	const highlight='highlight';
	const guarantee='guarantee';
	const headline_sets='headline_sets';
	
	static function AddShortCode($name,$display_name,$short_code,$image, $handler, $category=self::heading, $display=true, $register=true)
	{
		self::$controls[]=array('name'=>$name, 'display_name'=>$display_name, 'short_code'=>$short_code, 'image_url'=>$image, 'handler'=>$handler, 'category'=>$category, 'display'=>$display, 'register'=>$register);
	}
	static function RegisterShortCodes()
	{
		if(count(self::$controls)>0)
		{
			foreach(self::$controls as $control)
			{
				if($control['register']==true)
				{
					add_shortcode($control['name'], $control['handler']);
				}
			}
		}
	}
	static function LoadStyle()
	{
		ob_start();
		if(count(self::$styles)>0)
		{
			foreach(self::$styles as $style)
			{
				@include($style);
			}
		}
		return ob_get_clean();
	}
	static function LoadScript()
	{
		ob_start();
		if(count(self::$scripts)>0)
		{
			foreach(self::$scripts as $script)
			{
				@include($script);
			}
		}
		return ob_get_clean();
	}
	static function RegisterScript($path)
	{
		self::$scripts[]=$path;
	}
	static function RegisterStyle($path)
	{
		self::$styles[]=$path;
	}
	static function RenderScript()
	{
		//echo $script="alert('inserted');";return;
		$script="";
		if(count(self::$controls)>0)
		{
			foreach(self::$controls as $control)
			{
				//$script.='\r\n';
				$script.='if(selected_shortcode==\''.$control['name'].'\')';
				$script.='{';
				$script.='shortcodetext=\''.$control['short_code'].'\';';
				$script.='}';
			}
		}
		return $script;
	}
	static function RenderControls()
	{
		$content='<div class="wpheadline-wrapper" id="source">';
		$content_dest='<div class="wpheadline-wrapper" id="destination" style="display: none">';
		$i=0;
		if(count(self::$controls)>0)
		{
			foreach(self::$controls as $control)
			{
				if($control['display']==true)
				{
					$i++;
					$content.='<div class="wpheadline-control" data-id="id-'.$i.'" data-type="'.$control['category'].'">';
					$content_dest.='<div class="wpheadline-control" data-id="id-'.$i.'" data-type="'.$control['category'].'">';
					if(strlen($control['image_url'])>0)
					{
						$content.='<div class="wpheadline-image"><img src="'.$control['image_url'].'" /></div>';
						$content_dest.='<div class="wpheadline-image"><img src="'.$control['image_url'].'" /></div>';
						
					}
					$content.='<div class="wpheadline-heading">'.$control['display_name'].'</div>';
					$content_dest.='<div class="wpheadline-heading">'.$control['display_name'].'</div>';
					$content.='<div class="wpheadline-option"><input type="radio" name="style_shortcode_control" id="style_shortcode_'.$i.'" value="'.$control['name'].'" onclick="handler(\''.$control['name'].'\');" /></div>';
					$content_dest.='<div class="wpheadline-option"><input type="radio" name="style_shortcode_control" id="style_shortcode_'.$i.'" value="'.$control['name'].'" onclick="handler(\''.$control['name'].'\');" /></div>';
					$content.='</div>';
					$content_dest.='</div>';
				}
			}
		}
		$content.='';
		$content.='<br class="clear" />';
		$content_dest.='<br class="clear" />';
		$content.='</div>';
		$content_dest.='</div>';
		//return $content.$content_dest;
		return $content;
		//print_r(self::$controls);
	}
}
?>