<?php
/*
Plugin Name: WP Calculator Standard
Plugin URI:  http://wpcalculator.com/
Description: Create customized calculators for your wordpress blog. Add these calculators into widgets or anywhere in the blog using simple [{ShortCodes}]
Version: 1.5
Author: Kamran Chowdhury
Author URI: http://wpcalculator.com/
License: customer-license
*/

/**
 * Check Access to files from outside wordpress.
 * @return TRUE|FALSE
 */
function wpcustomacl_file($file, $frompath)
{
	return preg_match( '%'.$file.'%', $frompath) ;
}
if ( wpcustomacl_file ( basename(__FILE__), $_SERVER['PHP_SELF'] ) )
{ 
	die('Direct access not allowed!');
}

global $wpcustomcalc_db_version;
global $wpcustomcalc_name;
global $wpcustomexcerptlength;
$wpcustomcalc_db_version = '0.1';
$wpcustomcalc_name = 'WP Calculator';
error_reporting(0);

add_action('widgets_init', create_function('', 'return register_widget("wpcustomcalcWidget");'));
register_deactivation_hook(__FILE__,'wpcustomcalc_deactivate');
register_activation_hook(__FILE__,'wpcustomcalc_install');

function wpcustomcalc_install()
{
	global $wpcustomcalc_db_version;
	update_option( 'wpcustomcalc_db_version', $wpcustomcalc_db_version );
}



/**
 * deactivation
 */
function wpcustomcalc_deactivate()
{
	//@todo place this on deactivate event of plugins.
	if ( $installed_ver == TRUE) delete_option( 'wpcustomcalc_db_version' );
}



function wpcustomcalc_init() {
	if (!is_admin()) {
		wp_enqueue_script('jquery');
		wp_enqueue_script('jquery-form');
	}
}
add_action('init', 'wpcustomcalc_init');

function wpcustomcalc_tags($content) {
           $calculators =  get_option( 'wpc_calculators' );
            $identifiers = array();
            foreach($calculators as $index => $calc)
            {
                foreach($calc as $param => $node) {
                    if ($param == 'title')
                    {
                        $identifiers[] = $node;
                    }
                }
            }
            foreach($identifiers as $key => $val)
            {
				$calctag = '[{'. strtoupper($val) . '}]';
				if (preg_match("$calctag", $content))
				{
					if (!is_category() && !is_archive()) 
					$content = str_replace("$calctag", rendercalculator($val) , $content);
				}	
            }
return $content;
}
add_filter( "the_content", "wpcustomcalc_tags" );

function customexcerpt($content)
{
          $calculators =  get_option( 'wpc_calculators' );
            $identifiers = array();
            foreach($calculators as $index => $calc)
            {
                foreach($calc as $param => $node) {
                    if ($param == 'title')
                    {
                        $identifiers[] = $node;
                    }
                }
            }
            foreach($identifiers as $key => $val)
            {
                //val==title of calculator
                $calctag = '[{'. strtoupper($val) . '}]';
                if (preg_match("$calctag", $content))
                {
                    $content = str_replace("$calctag", " " , $content);
                }
            }


return $content;
}
add_filter( "the_excerpt", "customexcerpt");

function get_cal_by_title($title) {
	$calculators =  get_option( 'wpc_calculators' );
	$jc=0;
	foreach($calculators as $calc)
	{
		if($calc['title'] == $title) return $calc;
	}
}

function rendercalculator($calctitle)
{
$calculator = get_cal_by_title($calctitle);

$calctitle	= $calculator['title'];
$idtitle    = str_replace(" ","_",$calctitle);
$params		= $calculator['params'];

$buttontitle= $calculator['title_button'];
/* this is for results rendering , we use it in other part 
$heading	= $calculator['heading']; */
$results	= $calculator['results'];
foreach($results as $result)
{
	if ($result['send_email'])
	{
		$email = true;
	}
}

		$calcname = strtolower( str_replace(' ', '_', $calctitle) );
		
		extract($calculator['style']);


define ('WPCALCURL', site_url() . '/wp-content/plugins/wp-calculator-standard/');
$calctableheader = "<style type=\"text/css\"> #$idtitle table.calculator {  font-family: $fontface; font-size: $fontsize; font-color:$fontcolor; } #$idtitle table.calculator tr td { border-color: $backgroundcolor; padding: 5px;  background: $backgroundcolor; font-family: $fontface; font-size: $fontsize; font-color:$fontcolor } #$idtitle table.calculator tr { background: $backgroundcolor;  } </style>";
//$calctableheader .= "<script type=\"text/javascript\" src=\"". WPCALCURL ."js/jquery-1.4.3.min.js\"></script>";
//$calctableheader .= "<script type=\"text/javascript\" src=\"". WPCALCURL ."js/jquery.form.js\"></script>";
//$calctableheader .= "<script type=\"text/javascript\" src=\"". WPCALCURL ."/js/wpcustomcalc.js\"></script>";
$calctableheader .=
"\n<script type=\"text/javascript\">\n".
"(function(\$){\n".
"   \$(document).ready(function() {\n".
"       \$('#$idtitle').bind('submit', function(e) {\n".
"       	 e.preventDefault(); // <-- important\n".
"           \$(this).ajaxSubmit({\n".
"               target: '#wpcustomcalcresults_$idtitle'\n".
"           });\n".
"       });\n".
"   });\n".
"})(jQuery);\n".
"</script>\n";

$calctableheader .= "<form id=\"$idtitle\" name=\"$calctitle\" action=\"". WPCALCURL ."getresults.php\" method=\"POST\"><input type=\"hidden\" name=\"calctitle\" value=\"$calctitle\"><div style=\"overflow:auto; position:relative; font-family: $fontface ; font-size: $fontsize ; font-color: $fontcolor ;height: $height; width: $width; background: $backgroundcolor; border: $borderwidth solid $bordercolor  \"><table class=\"calculator\"><tr><th style=\"text-align:left;padding-bottom:5px\" colspan=\"3\"><h2>$calctitle</h2></th></tr>";
$arguments = array();
$param_index = 0;
foreach($params as $param)
{
	$paramtype =  $param['type'];
	$paramname =  $param['name'];

	if ( $paramtype == 'textbox' ) 
	{
		$arguments[] = $paramname;
	//	$calctablebody .= "<tr class=\"calculator\"><td class=\"calculator\" style=\"text-align:left\"><strong>$paramname</strong></td><td class=\"calculator\"><input size=\"15\" type=\"text\" name=\"param_$param_index\"></td><td></td></tr>";
				$calctablebody .= "<tr class=\"calculator\"><td class=\"calculator\" style=\"text-align:left\"><strong>$paramname</strong></td><td class=\"calculator\"><input type=\"text\" name=\"param_$param_index\"></td><td></td></tr>";
	} 
	if ( $paramtype == 'radio' )
	{
		$label_radio = true;
		$default = "checked=\"checked\"";
		foreach($param['options'] as $option) {
	            $name = $option['name'];
                $value= $option['value'];
				if ( $value == '' ) continue;
			if ($label_radio) {
				$arguments[] = $name;
				$calctablebody .= "<tr><td colspan=\"3\" style=\"text-align:left\"><strong></strong></td></tr>";
				$label_radio = false; //setted
			}
			$calctablebody .= "<tr class=\"calculator\"><td class=\"calculator\" colspan=\"2\" style=\"text-align:left\"><input $default type=\"radio\" name=\"param_$param_index\" value=\"$value\"> $name</td><td></td></tr>";
			$default ="";
		}
	}
	if ( $paramtype == 'selection' )
	{
		$label_select = true;
//		$calctablebody .= "<tr><td></td><td><select name=\"$name\">";
		foreach($param['options'] as $option) {
				$name = $option['name'];
				$value= $option['value'];
				if ( $value == '' ) continue;
			if ($label_select) {
				$arguments[] = $name;
			    $calctablebody .= "<tr class=\"calculator\"><td style=\"text-align:left\" class=\"calculator\"><strong>Select</select></td><td><select name=\"param_$param_index\">";
				$label_select = false;
			}
				$calctablebody .= "<option value=\"$value\">$name</option>";
		}							
		 $calctablebody .= "</select></td><td></td></tr>";				
	}
$param_index++;
}
$arguments = implode(",", $arguments);
if ( $email == true ) {
	$calctablebody .= "<tr class=\"calculator\"><td class=\"calculator\" colspan=\"1\" style=\"text-align:left\"><input type=\"checkbox\" name=\"sendemail\"><strong>Email Results</strong></td><td class=\"calculator\" colspan=\"2\"><input type=\"text\" name=\"email\"></td></tr>";
}
$calctablebody .= "<tr class=\"calculator\"><td colspan=\"3\" style=\"text-align:left\"><input type=\"submit\" value=\"$buttontitle\" class=\"button\"></td></tr>";
$calctablefooter = "<tr><td class=\"calculator\" colspan=\"3\"></td></tr></table><input type=\"hidden\" name=\"arguments\" value=\"$arguments\"></div></form>";
$calctablefooter .= "<div id=\"wpcustomcalcresults_$idtitle\"></div><br /></p />";

return $calctableheader . $calctablebody . $calctablefooter;
}


if ( is_admin() && function_exists( 'wpcustomcalc_menu_options' ))
{
    add_action( 'admin_menu', 'wpcustomcalc_menu_options' );
    add_filter( 'admin_menu', 'add_admin_menu_separator');
}

function wpcustomcalc_menu_options() {

define ('WPCALCURL', site_url() . '/wp-content/plugins/wpcalculator/');
$url = WPCALCURL;
	add_menu_page( __('WP Calculator', 'wpcustomcalc'),
                    __('WP Calculator','wpcustomcalc'), 'administrator',
                    'wpcustomcalcmenu', 'wpcustomcalc_menu', "$url/images/icon.png");

    add_submenu_page( 'wpcustomcalcmenu',
                __('WP Calculator','wpcustomcalc'),
                __('Create and Manage', 'wpcustomcalc'),
                'administrator', 'wpcustomcalcmenu', 'wpcustomcalc_menu');

  add_submenu_page( 'wpcustomcalcmenu',
                __('WP Calculator','wpcustomcalc'),
                __('Appearance', 'wpcustomcalc'),
                'administrator', 'wpcustomcalcmenu-styles', 'wpcustomcalc_styles');


    add_submenu_page( 'wpcustomcalcmenu',
                __('WP Calculator','wpcustomcalc'),
                __('Email Settings', 'wpcustomcalc'),
                'administrator', 'wpcustomcalcmenu-settings', 'wpcustomcalc_settings');

   add_submenu_page( 'wpcustomcalcmenu',
                __('WP Calculator','wpcustomcalc'),
                __('Download Emails', 'wpcustomcalc'),
                'administrator', 'wpcustomcalcmenu-csv', 'wpcustomcalc_csv');

}

function add_admin_menu_separator() {
        global $menu;
        $menu[0] = $menu[1];
        $menu[1] = array('','read',"separator0",'','wp-menu-separator');
}

function wpcustomcalc_csv() {

 if (!current_user_can('manage_options'))  {
        wp_die( __('You do not have sufficient permissions to access this page.') );
    }

	define ('WPCALCURL', site_url() . '/wp-content/plugins/wpcalculator/');
?>
  <h3>Emails saved in CSV Format</h3>
    <a href="<?php echo WPCALCURL ?>readcsv.php">Click here to download</a>

<?php
}


function wpcustomcalc_styles() {
 if (!current_user_can('manage_options'))  {
        wp_die( __('You do not have sufficient permissions to access this page.') );
    }

	$calculator = $_GET['calc']; 
	$calcname = strtolower( str_replace(' ', '_', $calculator) );	
	$calculators =  get_option( 'wpc_calculators' );
	#print_r($calculators);
	$tcalc = array();
	$ncalc = array();
	foreach($calculators as $key => $calcu) {
		if ( $calcu['title'] == $calculator ) {
			$tcalc[$key] = $calcu;
			if($_POST) {
				$tcalc[$key]['style'] = $_POST;
				$ncalc = $_POST;
			} else {
				$ncalc = $tcalc[$key]['style'];
			}
		} else {
			$tcalc[] = $calcu;
		}
	}	
	if ($_POST['update_styles'] == 1) {			
		update_option( 'wpc_calculators', $tcalc );		
	}

?>
 <h3>Calculator styling</h3>
 <p><em>This is a CSS Assistant, fill the form fields with CSS Values</em></p>

 <form name="?page=wpcustomcalcmenu-styles&calc=<?php echo $calculator ?>" method="POST">
 <table>
 <tr><td>Calculator</td><td>
          <select class="widefat" name="calculatorname" onchange="javascript:window.location='?page=wpcustomcalcmenu-styles&calc='+this.value">
          <?php
            $calculators =  get_option( 'wpc_calculators' );
            $identifiers = array();
            foreach($calculators as $index => $calc)
            {
                foreach($calc as $param => $node) {
                    if ($param == 'title')
                    {
                        $identifiers[] = $node;
                    }
                }
            }
            echo "<option value=\"calculator\">$calculator</option>";
            foreach($identifiers as $key => $val)
            {
				if ($calculator == $val) $default='default="default"';
				else $defatul = '';
				echo "<option value=\"$val\" $default>$val</option>";
            }
          ?>
          </select>

  </td></tr>
 <tr><td>Height</td><td><input type="text" name="height" value="<?php echo $ncalc['height']; ?>"> Example: 400px</td></tr>
 <tr><td>Width</td><td><input type="text" name="width" value="<?php echo $ncalc['width']; ?>"> Example: 250px</td></tr>
 <tr><td>Border Width</td><td><input type="text" name="borderwidth" value="<?php echo $ncalc['borderwidth']; ?>"> Example: 2px</td></tr>
 <tr><td>Border Color</td><td><input type="text" name="bordercolor" value="<?php echo $ncalc['bordercolor']; ?>"> Example: silver or #bbddee</td></tr>
 <tr><td>Background Color</td><td><input type="text" name="backgroundcolor" value="<?php echo $ncalc['backgroundcolor']; ?>"> Example: #ffffff</td></tr>
 <tr><td>Font Face</td><td><input type="text" name="fontface" value="<?php echo $ncalc['fontface']; ?>"> Example: Monaco, Tahoma, Times</td></tr>
 <tr><td>Font Color</td><td><input type="text" name="fontcolor" value="<?php echo $ncalc['fontcolor']; ?>"> Example: #444444</td></tr>
 <tr><td>Font Size</td><td><input type="text" name="fontsize" value="<?php echo $ncalc['fontsize']; ?>"> Example: 12px</td></tr>
 <tr><td></td><td>
 <input type="hidden" name="update_styles" value="1">
 <input type="submit" value="Save" class="button">
</td></tr>
 </table>
 </form>
<?php

}


function wpcustomcalc_settings() {
 if (!current_user_can('manage_options'))  {
        wp_die( __('You do not have sufficient permissions to access this page.') );
    }
	if ($_POST['update_email'] == 1) {
        $email_from = $_POST['email_from'];
		$email_reply_to = $_POST['email_reply_to'];
		$email_subjet = $_POST['email_subjet'];
		$email_header = $_POST['email_header'];
		$email_footer = $_POST['email_footer'];
		$data = array();
		$data['email_from'] = $email_from; update_option('email_from', $email_from);
		$data['email_reply_to'] = $email_reply_to; update_option('email_reply_to', $email_reply_to);
		$data['email_subjet'] = $email_subjet; update_option('email_subjet', $email_subjet);
		$data['email_header'] = $email_header; update_option('email_header', $email_header);
		$data['email_footer'] = $email_footer; update_option('email_footer', $email_footer);
		$data = serialize( $data );
        $path = dirname(__FILE__);
        $fp = fopen( $path."/settings".'.conf', 'w');
        fwrite($fp, $data);
        fclose($fp);	
	}

	?>
	<h3>Email settings</h3>
	<form action="?page=wpcustomcalcmenu-settings" method="POST">
	<table>
	<tr><td colspan="2"><p><strong>Server sender email settings</strong></p></td></tr>
	<tr><td><p><label>From</label></p></td><td><p><input name="email_from" type="text" value="<?php echo get_option('email_from') ?>"></p></td></tr>
	<tr><td><p><label>Reply-to</label></p></td><td><p><input name="email_reply_to" type="text" value="<?php echo get_option('email_reply_to') ?>"></p></td></tr>
	<tr><td><p><label>Subjet</label></p></td><td><p><input name="email_subjet" type="text" value="<?php echo get_option('email_subjet') ?>"></p></td></tr>
	<tr valign="top"><td><p><label>Email Intro</label></p></td><td><p><textarea name="email_header"><?php echo get_option('email_header') ?></textarea></p></td></tr>
<tr valign="top"><td><p><label>Email Conclusion</label></p></td><td><p><textarea name="email_footer"><?php echo get_option('email_footer') ?></textarea></p></td></tr>
	<tr><td colspan="1"></td><td><p><input type="submit" class="button" value="Save settings"></p></td></tr>
	</table>
	<input type="hidden" name="update_email" value="1">
	</form>
	<br />
	<?php
}

function wpcustomcalc_menu() {
    if (!current_user_can('manage_options'))  {
        wp_die( __('You do not have sufficient permissions to access this page.') );
    }


function iscalcexists($calcname) {
//clean untitled calculators and @todo: other validations here.
$calculators =  get_option( 'wpc_calculators' );
foreach($calculators as $key => $calc)
{
    if ( $calcname == $calc['title'] )
    {
		return true;
    }
}
return false;
}//end func. iscalexists



//save calc
if ($_POST['calc']) {
	#print_r($_POST['calc']);
	$calculators = array();
	$calculators = get_option( 'wpc_calculators' );
	$calc = $_POST['calc'];
	if($_GET['action'] == 'update') {
		$tcalc = array();
		foreach($calculators as $key => $calcu) {
			if ( $calcu['title'] == $calc['ttitle'] ) {				
				$calc['style'] = $calcu[$key]['style'];
				$tcalc[] = $calc;
			} else {
				$tcalc[] = $calcu;
			}
		}
		update_option( 'wpc_calculators', $tcalc );
	} else {
		if (! iscalcexists( $calc['title'] ) ) {
				$calculators[] = $calc;			
				update_option( 'wpc_calculators', $calculators );
				?>
				<div style="margin-top:10px;padding:10px;border: 2px solid silver;  width:60%">
				<h4 style="color:red">The calculator <?php echo $calc['title'] ?> has been created!</h4>
				<small style="#444444">You can list and edit calculators in the <em>Manage Calculators</em> area</small>
				</div>
				<?php
		} else {
				$existingcalc = $calc['title'];
				$calc['title'] = 'tmpcalc';
				$datacalc = serialize( $calc );
			 	$calculators[] = $calc;
			 	update_option( 'wpc_calculators', $calculators );
			?>
			<div style="margin-top:10px;padding:10px;border: 2px solid silver;  width:60%">
			<h4 style="color:red">A calculator with this name '<?php echo $existingcalc ?>' already exists!</h4>
			<small style="#444444">Please, <a href="?page=wpcustomcalcmenu&tab=manage&action=edit&calcname=tmpcalc">Edit it and change the name</a> for your calculator</small>
			</div>
			<script type="text/javascript">
				window.location = '?page=wpcustomcalcmenu&tab=manage&action=edit&calcname=tmpcalc';
			</script>
			<?php
		}
	}
	
}

//clean untitled calculators and @todo: other validations here.
$calculators =  get_option( 'wpc_calculators' );
foreach($calculators as $index => $calc)
{
	foreach($calc as $param => $node) {
		if ( $param == 'title' && $node == '' )
		{
			unset( $calculators[ $index ] );
		}
	}
}
update_option( 'wpc_calculators', $calculators );

/*
echo '<pre>';
print_r( get_option( 'wpc_calculators' ) );
echo '</pre>';
*/
?>
<p>&nbsp;</p>
<h3><?php include("wcc-nav.php"); ?></h3>
<?php
	$opt = addslashes($_GET['tab']);
	switch($opt) {
	case 'manage': include "custom_calc_manage.php"; break;
	case 'export': include "custom_calc_export.php"; break;
	case 'import': include "custom_calc_import.php"; break;
	default: include "custom_calc_create.php"; break;
	}


}



/**
 * FooWidget Class
 */
class wpcustomcalcWidget extends WP_Widget {
    /** constructor */
    function wpcustomcalcWidget() {
        global $wpcustomcalc_name;
		parent::WP_Widget(FALSE, $name = $wpcustomcalc_name );	
    }

    /** @see WP_Widget::widget */
	function widget($args, $instance) {	
	//http://codex.wordpress.org/Widgets_API	
        extract( $args );
        $title = apply_filters('widget_title', $instance['calculator']);
			echo $before_widget; 
				if ( $title )
//					echo $before_title . $title . $after_title;

		echo rendercalculator($title); 
	//	echo "Hola"; //this print on widget client area.
		echo $after_widget;	
				
    }

    /** @see WP_Widget::update */
    function update($new_instance, $old_instance) {				
		$instance = $old_instance;
		$instance['calculator'] = strip_tags($new_instance['calculator']);
        return $instance;
    }

    /** @see WP_Widget::form */
    function form($instance) {				
		$calculator = esc_attr( $instance['calculator'] );
		?>
		<p>
          <label for="<?php echo $this->get_field_id('calculator') ?>"><?php _e('Select a calculator for this widget'); ?></label> 
          <select class="widefat" id="<?php echo $this->get_field_id('calculator') ?>" name="<?php echo $this->get_field_name('calculator') ?>">
		  <?php 
			$calculators =  get_option( 'wpc_calculators' );
			$identifiers = array();
			foreach($calculators as $index => $calc)
			{
			    foreach($calc as $param => $node) {
		        	if ($param == 'title')
			        {
			            $identifiers[] = $node;
			        }
		    	}
			}
			echo "<option value=\"calculator\">$calculator</option>";
			foreach($identifiers as $key => $val)
			{
				echo "<option value=\"$val\">$val</option>";
			}
		  ?>
		  </select>
        </p>
	<?php

	}	
} // class FooWidget

?>
