(function() {
	tinymce.create('tinymce.plugins.exitpopupbuttonPlugin', {
		init : function(ed, url) {
			// Register commands
			ed.addCommand('exitpopupmcebutton', function() {
				ed.windowManager.open({
					title : 'Add ExitPopupContentEditor Button',
					file : url + '/exitpopupcontenteditor_manager.php', // file that contains HTML for our modal window
					width : 750 + parseInt(ed.getLang('button.delta_width', 0)), // size of our window
					height : 300 + parseInt(ed.getLang('button.delta_height', 0)), // size of our window
					inline : 1,
					resizable:true
					
				}, {
					plugin_url : url
				});
			});
			 
			// Register buttons
			ed.addButton('exitpopupeditor_button', {title : 'ExitPopup', cmd : 'exitpopupmcebutton', image: url + '/includes/images/exitpopupeditor.gif' });
		},
		 
		getInfo : function() {
			return {
				longname : 'Insert Button',
				author : 'Veena Prahsanth',
				authorurl : 'http://WickedCoolPlugins.com',
				infourl : 'http://WickedCoolPlugins.com',
				version : tinymce.majorVersion + "." + tinymce.minorVersion
			};
		}
	});
	 
	// Register plugin
	// first parameter is the button ID and must match ID elsewhere
	// second parameter must match the first parameter of the tinymce.create() function above
	tinymce.PluginManager.add('exitpopupeditor_button', tinymce.plugins.exitpopupbuttonPlugin);

})();